import numpy as np
class Topic:
    """
    Topics for mqtt communication
    """
    BEACON = "beacon"
    DATA = "data"
    LANGUAGE = "language"
    REPRESENTATION = "representation"


# python json stringingfy can't tolerate embbeded objects..... everything to basic type
# can't have any functions, must be a clean data structure class for json....
class Beacon(object):
    def __init__(self, _id, _FrameId,
                 _x, _y, _z,
                 _yaw, _pitch, _roll,
                 _DimX, _DimY, _DimZ,
                 _speed,
                 _sensor_view_dict,
                 _sensor_object_dict,
                 _trigger):
        self.id = _id
        self.topic = Topic.BEACON
        self.FrameId = _FrameId
        self.x = _x
        self.y = _y
        self.z = _z
        self.yaw = _yaw
        self.roll = _roll
        self.pitch = _pitch
        self.DimX = _DimX
        self.DimY = _DimY
        self.DimZ = _DimZ
        self.speed = [_speed.x, _speed.y, _speed.z]
        self.cached_sensor_view_size = []
        self.cached_sensor_object_size = []
        for key in _sensor_view_dict:
            self.cached_sensor_view_size.append(_sensor_view_dict[key].shape[0])
        for key in _sensor_object_dict:
            self.cached_sensor_object_size.append(_sensor_object_dict[key].shape[0])
        self.trigger = _trigger

class Language(object):
    def __init__(self, _id, _agent_id, FrameId,
                 _x, _y, _z,
                 _yaw, _pitch, _roll,
                 _language_message,):
        self.id = _id
        self.vehicle_id = _id
        self.agent_id = _agent_id
        self.topic = Topic.LANGUAGE
        self.FrameId = FrameId
        self.x = np.round(_x, 2)
        self.y = np.round(_y, 2)
        self.z = np.round(_z, 2)
        self.yaw = np.round(_yaw, 2)
        self.roll = np.round(_roll, 2)
        self.pitch = np.round(_pitch, 2)
        self.language_message = _language_message

class Representation(object):
    def __init__(self, _id, _agent_id, FrameId,
                 _x, _y, _z,
                 _yaw, _pitch, _roll,
                 _representation, _xyz, _transform):
        self.id = _id
        self.vehicle_id = _id
        self.agent_id = _agent_id
        self.topic = Topic.REPRESENTATION
        self.FrameId = FrameId
        self.x = np.round(_x, 2)
        self.y = np.round(_y, 2)
        self.z = np.round(_z, 2)
        self.yaw = np.round(_yaw, 2)
        self.roll = np.round(_roll, 2)
        self.pitch = np.round(_pitch, 2)
        self.representation = _representation
        self.xyz = _xyz
        self.transform = _transform
